jQuery(document).ready(function($) {
    'use strict';

    /**
     * Handles the tabbed interface in the metabox on the Edit Link screen.
     */
    $('.pla-metabox-wrapper .nav-tab').on('click', function(e) {
        e.preventDefault();
        var $this = $(this);
        var target = $this.attr('href');

        $this.addClass('nav-tab-active').siblings().removeClass('nav-tab-active');
        $(target).addClass('active').siblings('.pla-tab-content').removeClass('active');
    });

    /**
     * Handles the AJAX request for resetting click counts.
     * This now works on both the "All Links" list and the "Edit Link" screen.
     */
    // We use event delegation on the body so it works everywhere.
    $('body').on('click', '.pla-reset-click', function(e) {
        e.preventDefault();

        if (!confirm('Are you sure you want to reset the click count to zero?')) {
            return;
        }

        var $button = $(this);
        var postId = $button.data('postid');
        var nonce = $button.data('nonce');
        var $clickCountSpan = $('#pla-click-count-' + postId); // This targets the correct counter

        // Show visual feedback that something is happening
        $button.hide();
        var $spinner = $('<span class="spinner is-active" style="display:inline-block; float:none; margin-left:10px;"></span>');
        $button.after($spinner);


        $.ajax({
            url: ajaxurl, // ajaxurl is a global variable provided by WordPress
            type: 'POST',
            data: {
                action: 'pla_reset_clicks', // This must match the PHP hook
                post_id: postId,
                nonce: nonce
            },
            success: function(response) {
                if (response.success) {
                    // Update the click count to 0 and make it green temporarily
                    $clickCountSpan.text(response.data.new_count).css('color', 'green');
                    setTimeout(function() {
                        $clickCountSpan.css('color', ''); // Reset color
                    }, 2000);
                } else {
                    alert('Failed to reset clicks: ' + response.data.message);
                }
            },
            error: function() {
                alert('An error occurred while trying to reset clicks. Please try again.');
            },
            complete: function() {
                // Remove the spinner and show the button again
                $spinner.remove();
                $button.show();
            }
        });
    });
});