<?php
if (!defined('ABSPATH')) exit;

function pla_add_settings_page() {
    add_submenu_page(
        'edit.php?post_type=pretty-link',
        'Settings',
        'Settings',
        'manage_options',
        'pla-settings',
        'pla_render_settings_page'
    );
}
add_action('admin_menu', 'pla_add_settings_page');

function pla_render_settings_page() {
    ?>
    <div class="wrap">
        <h1>Pretty Links Alternative - Settings</h1>
        <form method="post" action="options.php">
            <?php
            settings_fields('pla_settings_group');
            do_settings_sections('pla-settings');
            submit_button();
            ?>
        </form>
    </div>
    <?php
}

function pla_register_settings() {
    register_setting('pla_settings_group', 'pla_base_slug', [
        'type' => 'string',
        'sanitize_callback' => 'sanitize_title',
        'default' => 'go'
    ]);

    add_settings_section('pla_general_settings', 'General Settings', null, 'pla-settings');

    add_settings_field('pla_base_slug', 'Redirect Base Slug', 'pla_base_slug_cb', 'pla-settings', 'pla_general_settings');
}
add_action('admin_init', 'pla_register_settings');

function pla_base_slug_cb() {
    $base_slug = get_option('pla_base_slug', 'go');
    echo '<input type="text" name="pla_base_slug" value="' . esc_attr($base_slug) . '" />';
    echo '<p class="description">The base part of the URL. Example: <code>' . get_site_url() . '/<strong>' . esc_attr($base_slug) . '</strong>/my-link</code></p>';
}