<?php
if (!defined('ABSPATH')) exit;

add_action('add_meta_boxes', 'pla_add_metaboxes');
add_action('save_post_pretty-link', 'pla_save_link_data', 10, 2);
add_action('wp_ajax_pla_reset_clicks', 'pla_ajax_reset_clicks');

function pla_add_metaboxes() {
    add_meta_box('pla_link_settings', 'Link Settings', 'pla_link_settings_cb', 'pretty-link', 'normal', 'high');
}

/**
 * THIS IS THE NEW, FULLY FUNCTIONAL SAVE FUNCTION.
 * It reliably saves all fields from all tabs.
 */
function pla_save_link_data($post_id, $post) {
    if (!isset($_POST['pla_link_nonce']) || !wp_verify_nonce($_POST['pla_link_nonce'], 'pla_save_link_data')) return;
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    if (!current_user_can('edit_post', $post_id)) return;
    if ($post->post_type != 'pretty-link') return;

    // --- Save Slug ---
    if (isset($_POST['post_name'])) {
        $new_slug = sanitize_title($_POST['post_name']);
        if ($post->post_name !== $new_slug) {
            remove_action('save_post_pretty-link', 'pla_save_link_data', 10);
            wp_update_post(['ID' => $post_id, 'post_name' => $new_slug]);
            add_action('save_post_pretty-link', 'pla_save_link_data', 10, 2);
        }
    }
    
    // --- Save Basic Meta Fields ---
    $fields = ['pla_target_url', 'pla_redirect_type', 'pla_notes'];
    foreach ($fields as $field) {
        if (isset($_POST[$field])) {
            update_post_meta($post_id, '_' . $field, sanitize_text_field($_POST[$field]));
        }
    }
    
    // --- Save Advanced Checkboxes ---
    $checkboxes = ['pla_nofollow', 'pla_sponsored', 'pla_param_forwarding', 'pla_tracking'];
    foreach ($checkboxes as $checkbox) {
        update_post_meta($post_id, '_' . $checkbox, isset($_POST[$checkbox]) ? '1' : '0');
    }
}

function pla_link_settings_cb($post) {
    wp_nonce_field('pla_save_link_data', 'pla_link_nonce');
    ?>
    <div class="pla-metabox-wrapper">
        <nav class="nav-tab-wrapper">
            <a href="#pla-tab-basic" class="nav-tab nav-tab-active">Basic</a>
            <a href="#pla-tab-advanced" class="nav-tab">Advanced</a>
        </nav>
        <div id="pla-tab-basic" class="pla-tab-content active"><?php pla_render_basic_tab($post); ?></div>
        <div id="pla-tab-advanced" class="pla-tab-content"><?php pla_render_advanced_tab($post); ?></div>
    </div>
    <?php
}

function pla_render_basic_tab($post) { /* ... unchanged ... */ }
function pla_render_advanced_tab($post) { /* ... unchanged ... */ }

// The render functions are unchanged, but included for completeness.
function pla_render_basic_tab($post) {
    $target_url    = get_post_meta($post->ID, '_pla_target_url', true);
    $redirect_type = get_post_meta($post->ID, '_pla_redirect_type', true) ?: '307';
    $notes         = get_post_meta($post->ID, '_pla_notes', true);
    $base_slug     = get_option('pla_base_slug', 'go');
    ?>
    <table class="form-table">
        <tr>
            <th><label for="pla_target_url">Target URL</label></th>
            <td><input type="url" id="pla_target_url" name="pla_target_url" value="<?php echo esc_url($target_url); ?>" class="large-text" required /></td>
        </tr>
        <tr>
            <th><label for="post_name">Pretty Link Slug</label></th>
            <td>
                <span class="pla-base-url"><?php echo esc_url(get_site_url() . '/' . $base_slug . '/'); ?></span>
                <input type="text" name="post_name" id="post_name" value="<?php echo esc_attr($post->post_name); ?>" />
            </td>
        </tr>
        <tr>
            <th><label for="pla_redirect_type">Redirection</label></th>
            <td><select name="pla_redirect_type" id="pla_redirect_type"><option value="307" <?php selected($redirect_type, '307'); ?>>307 (Temporary)</option><option value="302" <?php selected($redirect_type, '302'); ?>>302 (Temporary)</option><option value="301" <?php selected($redirect_type, '301'); ?>>301 (Permanent)</option></select></td>
        </tr>
        <tr>
            <th><label for="pla_notes">Notes</label></th>
            <td><textarea name="pla_notes" id="pla_notes" class="large-text" rows="4"><?php echo esc_textarea($notes); ?></textarea></td>
        </tr>
    </table>
    <?php
}

function pla_render_advanced_tab($post) {
    $is_new_post      = get_current_screen()->action === 'add';
    $nofollow         = get_post_meta($post->ID, '_pla_nofollow', true);
    $sponsored        = get_post_meta($post->ID, '_pla_sponsored', true);
    $param_forwarding = get_post_meta($post->ID, '_pla_param_forwarding', true);
    $tracking         = get_post_meta($post->ID, '_pla_tracking', true);
    ?>
    <table class="form-table">
        <tr>
            <th>Link Options</th>
            <td>
                <p><label><input type="checkbox" name="pla_nofollow" value="1" <?php checked($is_new_post || $nofollow === '1'); ?>> No Follow</label></p>
                <p><label><input type="checkbox" name="pla_sponsored" value="1" <?php checked($sponsored === '1'); ?>> Sponsored</label></p>
            </td>
        </tr>
        <tr>
            <th>Parameter Forwarding</th>
            <td><label><input type="checkbox" name="pla_param_forwarding" value="1" <?php checked($param_forwarding === '1'); ?>> Enable</label></td>
        </tr>
        <tr>
            <th>Tracking</th>
            <td><label><input type="checkbox" name="pla_tracking" value="1" <?php checked($is_new_post || $tracking === '1'); ?>> Enable Click Tracking</label></td>
        </tr>
    </table>
    <?php
}

/**
 * Handles the AJAX request to reset click counts.
 */
function pla_ajax_reset_clicks() {
    $post_id = isset($_POST['post_id']) ? (int)$_POST['post_id'] : 0;
    if (!$post_id || !check_ajax_referer('pla_reset_nonce_' . $post_id, 'nonce', false)) {
        wp_send_json_error(['message' => 'Security check failed.']);
    }
    if (!current_user_can('edit_post', $post_id)) {
        wp_send_json_error(['message' => 'Permission denied.']);
    }
    
    update_post_meta($post_id, '_pla_click_count', 0);
    wp_send_json_success(['new_count' => 0]);
}