<?php
if (!defined('ABSPATH')) exit;

function pla_redirect_handler() {
    global $wpdb;
    
    // Check if the request URI is just the site URL, to avoid unnecessary processing on the homepage.
    if (empty($_SERVER['REQUEST_URI']) || in_array($_SERVER['REQUEST_URI'], ['/', ''])) {
        return;
    }

    $request_path = trim(strtolower(strtok($_SERVER['REQUEST_URI'], '?')), '/');
    if (empty($request_path)) return;
    
    $base_slug = get_option('pla_base_slug', 'go');

    if (strpos($request_path, $base_slug . '/') === 0) {
        $link_slug = basename($request_path);
        if (!$link_slug) return;

        $post_id = $wpdb->get_var($wpdb->prepare(
            "SELECT ID FROM {$wpdb->posts} WHERE post_name = %s AND post_type = 'pretty-link' AND post_status = 'publish' LIMIT 1",
            $link_slug
        ));

        if ($post_id) {
            $target_url = get_post_meta($post_id, '_pla_target_url', true);
            if (empty($target_url)) return;

            if (get_post_meta($post_id, '_pla_tracking', true) == '1') {
                $click_count = (int)get_post_meta($post_id, '_pla_click_count', true);
                update_post_meta($post_id, '_pla_click_count', $click_count + 1);
            }

            if (get_post_meta($post_id, '_pla_param_forwarding', true) == '1' && !empty($_SERVER['QUERY_STRING'])) {
                $target_url .= (strpos($target_url, '?') === false ? '?' : '&') . $_SERVER['QUERY_STRING'];
            }

            if (get_post_meta($post_id, '_pla_nofollow', true) == '1') {
                header('X-Robots-Tag: noindex, nofollow', true);
            }
            if (get_post_meta($post_id, '_pla_sponsored', true) == '1') {
                header('Link: <' . $target_url . '>; rel="sponsored"', false);
            }

            $redirect_type = (int)get_post_meta($post_id, '_pla_redirect_type', true) ?: 307;
            wp_redirect(esc_url_raw($target_url), $redirect_type);
            exit;
        }
    }
}
add_action('init', 'pla_redirect_handler', 1);