<?php
if (!defined('ABSPATH')) exit;

add_action('init', 'pla_register_post_type');
add_filter('manage_pretty-link_posts_columns', 'pla_admin_columns');
add_action('manage_pretty-link_posts_custom_column', 'pla_custom_column_content', 10, 2);

function pla_register_post_type() {
    $labels = [
        'name'                  => _x('Pretty Links', 'Post type general name', 'pla'),
        'singular_name'         => _x('Pretty Link', 'Post type singular name', 'pla'),
        'menu_name'             => _x('Pretty Links Alt', 'Admin Menu text', 'pla'),
        'add_new'               => __('Add Link', 'pla'),
        'add_new_item'          => __('Add New Link', 'pla'),
        'edit_item'             => __('Edit Link', 'pla'),
        'all_items'             => __('All Links', 'pla'),
    ];

    $args = [
        'labels'             => $labels,
        'public'             => false,
        'publicly_queryable' => true,
        'show_ui'            => true,
        'show_in_menu'       => true,
        'rewrite'            => ['slug' => get_option('pla_base_slug', 'go'), 'with_front' => false],
        'capability_type'    => 'post',
        'has_archive'        => false,
        'hierarchical'       => false,
        'menu_position'      => 20,
        'menu_icon'          => 'dashicons-admin-links',
        'supports'           => ['title'],
    ];
    register_post_type('pretty-link', $args);
}

function pla_admin_columns($columns) {
    return [
        'cb'          => $columns['cb'],
        'title'       => __('Link Title', 'pla'),
        'pretty_link' => __('Pretty Link', 'pla'),
        'clicks'      => __('Clicks', 'pla'),
        'target_url'  => __('Target URL', 'pla'),
        'date'        => $columns['date'],
    ];
}

function pla_custom_column_content($column, $post_id) {
    switch ($column) {
        case 'pretty_link':
            $base_slug = get_option('pla_base_slug', 'go');
            $post = get_post($post_id);
            $pretty_link = rtrim(get_site_url(), '/') . '/' . $base_slug . '/' . $post->post_name;
            echo '<a href="' . esc_url($pretty_link) . '" target="_blank">' . esc_url(urldecode($pretty_link)) . '</a><input type="text" value="'.esc_attr($pretty_link).'" readonly onfocus="this.select();" style="width:100%; margin-top:4px;"/>';
            break;
            
        case 'target_url':
            echo esc_url(get_post_meta($post_id, '_pla_target_url', true));
            break;

        case 'clicks':
            $click_count = get_post_meta($post_id, '_pla_click_count', true) ?: '0';
            echo '<div class="pla-clicks-column">';
            echo '<span class="pla-click-count-number" id="pla-click-count-' . $post_id . '">' . absint($click_count) . '</span>';
            echo '<a href="#" class="pla-reset-click" data-postid="' . $post_id . '" data-nonce="' . wp_create_nonce('pla_reset_nonce_' . $post_id) . '" title="Reset click count">Reset</a>';
            echo '</div>';
            break;
    }
}